<div class="mb-3">
    <div class="col-md-2">{!! Form::label('company_name', 'Company Name <strong class="text-danger"> * </strong>') !!}
    </div>
    <div class="col-md-6"> {{ Form::text('company_name', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">{!! Form::label('phone', 'Phone Number <strong class="text-danger"> * </strong>') !!}</div>
    <div class="col-md-6"> {{ Form::text('phone', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">{!! Form::label('email', 'Email <strong class="text-danger"> * </strong>') !!}</div>
    <div class="col-md-6"> {{ Form::email('email', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">{!! Form::label('tin', 'TIN <strong class="text-danger"> * </strong>') !!}</div>
    <div class="col-md-6"> {{ Form::text('tin', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">{!! Form::label('account_no', 'Account No <strong class="text-danger"> * </strong>') !!}</div>
    <div class="col-md-6"> {{ Form::text('account_no', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">{!! Form::label('bank', 'Bank Name <strong class="text-danger"> * </strong>') !!}</div>
    <div class="col-md-6"> {{ Form::text('bank', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">{!! Form::label('supply_items', 'Item Supplied <strong class="text-danger"> * </strong>') !!}
    </div>
    <div class="col-md-6"> {{ Form::text('supply_items', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">
        {!! Form::label('weekly_comsp', 'Weekly Consumption <strong class="text-danger"> * </strong>') !!}
    </div>
    <div class="col-md-6"> {{ Form::text('weekly_comsp', null, ['class' => 'form-control', 'required']) }}</div>
</div>

<div class="mb-3">
    <div class="col-md-2">
        {!! Form::label('cons_day', 'Day for Consumption <strong class="text-danger"> * </strong>') !!}
    </div>

    <div class="col-md-6" data-select2-id="77">
        <div class="select2-dark mb-3" data-select2-id="76">
            <div class="position-relative" data-select2-id="75">
                <select name="cons_day[]" id="select2Dark" class="select2 form-select select2-hidden-accessible"
                    multiple data-select2-id="select2Dark" tabindex="-1" aria-hidden="true">
                    @if(isset($aggregator))
                        <option {{ in_array("Monday", $aggregator->cons_day) ? 'selected' : ''}} value="Monday">Monday
                        </option>
                        <option {{ in_array("Tuesday", $aggregator->cons_day) ? 'selected' : ''}} value="Tuesday">Tuesday
                        </option>
                        <option {{ in_array("Wednesday", $aggregator->cons_day) ? 'selected' : ''}} value="Wednesday">
                            Wednesday</option>
                        <option {{ in_array("Thursday", $aggregator->cons_day) ? 'selected' : ''}} value="Thursday">Thursday
                        </option>
                        <option {{ in_array("Friday", $aggregator->cons_day) ? 'selected' : ''}} value="Friday">Friday
                        </option>
                        <option {{ in_array("Saturday", $aggregator->cons_day) ? 'selected' : ''}} value="Saturday">Saturday
                        </option>
                        <option {{ in_array("Sunday", $aggregator->cons_day) ? 'selected' : ''}} value="Sunday">Sunday
                        </option>
                    @else
                        <option value="Monday">Monday</option>
                        <option value="Tuesday">Tuesday</option>
                        <option value="Wednesday">Wednesday</option>
                        <option value="Thursday">Thursday</option>
                        <option value="Friday">Friday</option>
                        <option value="Saturday">Saturday</option>
                        <option value="Sunday">Sunday</option>
                    @endif
                </select>
            </div>
        </div>
    </div>

    <div class="mb-3">
        <div class="col-md-2">{!! Form::label('unit_cost', 'Unit Cost(N) <strong class="text-danger"> * </strong>') !!}
        </div>
        <div class="col-md-6"> {{ Form::text('unit_cost', null, ['class' => 'form-control', 'required']) }}</div>
    </div>

    <div class="mb-3">
        <div class="col-md-2">
            {!! Form::label('feed_pupils', 'Number of Children <strong class="text-danger"> * </strong>') !!}
        </div>
        <div class="col-md-6"> {{ Form::number('feed_pupils', null, ['class' => 'form-control', 'required']) }}</div>
    </div>

    <div class="mb-3">
        <div class="col-md-2">{!! Form::label('week_cost', 'Cost Per Week <strong class="text-danger"> * </strong>') !!}
        </div>
        <div class="col-md-6">
            <input class="form-control" required readonly name="week_cost" type="number"
                value="{{ isset($aggregator['week_cost']) ? $aggregator['week_cost'] : '' }}" id="week_cost">
        </div>
    </div>

    <div class="mb-3">
        <div class="col-md-2">
            {!! Form::label('amount_twenty', 'Amount for 20 Days <strong class="text-danger"> * </strong>') !!}
        </div>
        <div class="col-md-6">
            <input class="form-control" required readonly name="amount_twenty" type="number"
                value="{{ isset($aggregator['amount_twenty']) ? $aggregator['amount_twenty'] : '' }}"
                id="amount_twenty">
        </div>
    </div>

    @if(auth()->user()->hasrole('Admin'))
        <div class="mb-3">
            <div class="col-md-2">{!! Form::label('state', 'State <strong class="text-danger"> * </strong>') !!}</div>
            <div class="col-md-6">
                {{ Form::select('state', $states, null, ['class' => 'form-control', 'id' => 'state', 'placeholder' => '--please select--', 'required']) }}
            </div>
        </div>

        <div class="mb-3">
            <div class="col-md-2">{!! Form::label('is_verified', 'Verified <strong class="text-danger"> * </strong>') !!}
            </div>
            <div class="col-md-6">
                {{ Form::select('is_verified', [0 => 'Unverified', 1 => 'Verified'], null, ['class' => 'form-control', 'required']) }}
            </div>
        </div>

        <div class="mb-3">
            <div class="col-md-2">{!! Form::label('status', 'Status <strong class="text-danger"> * </strong>') !!}</div>
            <div class="col-md-6">
                {{ Form::select('status', \App\Helpers\StaticData::account_status(), null, ['class' => 'form-control', 'required']) }}
            </div>
        </div>
    @else
        @if (Request::route()->named('aggregators.create'))
            <div class="mb-3">
                <div class="col-md-2">{!! Form::label('status', 'Status <strong class="text-danger"> * </strong>') !!}</div>
                <div class="col-md-6">
                    {{ Form::select('status', ['Pending' => 'Pending'], null, ['class' => 'form-control', 'required']) }}
                </div>
            </div>
        @endif
    @endif

    @section('custom-js')
        <script>
            $("#state").select2();
            $("#program_manager_id").select2();   
        </script>
    @endsection